﻿using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;

namespace UUN
{
    /// <summary>
    /// 对图片水印操作的类
    /// </summary>
    public class 水印
    {
        /// <summary>
        /// 向某个图片文件增加水印
        /// </summary>
        /// <param name="图片位置">图片文件的位置</param>
        public void 增加水印(String 图片位置)
        {
            Bitmap 位图 = new Bitmap(图片位置);
            增加水印(位图).Save(图片位置);
        }
        /// <summary>
        /// 向图片增加水印，设置为网站的默认设置
        /// </summary>
        /// <param name="图片">要增加水印的图片</param>
        /// <returns></returns>
        public Image 增加水印(Image 图片)
        {
            if (!Convert.ToBoolean(程序.设置["水印设置_水印类型"]))
                return 增加图片水印(图片,
                    Convert.ToString(程序.设置["水印设置_水印图片"]),
                    Convert.ToInt32(程序.设置["水印设置_水印位置"]),
                    Convert.ToInt32(程序.设置["水印设置_水印图片透明度"]));
            else
                return 增加文字水印(图片,
                    Convert.ToInt32(程序.设置["水印设置_水印位置"]),
                    Convert.ToString(程序.设置["水印设置_水印文字"]),
                    常用.十六进制颜色(Convert.ToString(程序.设置["水印设置_水印文字颜色"])),
                    Convert.ToString(程序.设置["水印设置_水印文字字体"]),
                    Convert.ToInt32(程序.设置["水印设置_水印文字大小"]),
                    Convert.ToBoolean(程序.设置["水印设置_水印文字是否加粗"]));
        }
        /// <summary>
        /// 向图片增加图片水印
        /// </summary>
        /// <param name="图片">要增加水印的图片</param>
        /// <param name="水印的文件名">水印图片的位置</param>
        /// <param name="绘制位置">要绘制到图片的位置</param>
        /// <param name="透明度">图片的透明度</param>
        /// <returns>生成结果</returns>
        public Image 增加图片水印(Image 图片, String 水印文件名, int 绘制位置, int 透明度)
        {
            Bitmap 位图 = new Bitmap(图片.Width, 图片.Height);
            Graphics 绘图 = Graphics.FromImage(位图);
            //绘图.InterpolationMode = InterpolationMode.HighQualityBilinear;
            //绘图.SmoothingMode = SmoothingMode.HighSpeed;

            绘图.DrawImage(图片, 0, 0,图片.Width,图片.Height);

            Image 水印图片 = new Bitmap(System.Web.HttpContext.Current.Server.MapPath(水印文件名));
            if (水印图片.Height >= 图片.Height || 水印图片.Width >= 图片.Width)
                return 图片;

            ImageAttributes 图片属性 = new ImageAttributes();
            ColorMap 颜色映射 = new ColorMap();
            颜色映射.OldColor = Color.FromArgb(255, 0, 0, 0);
            颜色映射.NewColor = Color.FromArgb(0, 0, 0, 0);
            图片属性.SetBrushRemapTable(new ColorMap[] { 颜色映射 });
            float _透明度 = 0.5F;
            if (透明度 >= 1 && 透明度 <= 10)
                _透明度 = 透明度 / 10.0F;

            float[][] 颜色矩阵节点 ={
                new float[]{1.0f,0.0f,0.0f,0.0f,0.0f},
                new float[]{0.0f,1.0f,0.0f,0.0f,0.0f},
                new float[]{0.0f,0.0f,1.0f,0.0f,0.0f},
                new float[]{0.0f,0.0f,0.0f,_透明度,0.0f},
                new float[]{0.0f,0.0f,0.0f,0.0f,1.0f}
            };
            ColorMatrix 颜色矩阵 = new ColorMatrix(颜色矩阵节点);
            图片属性.SetColorMatrix(颜色矩阵, ColorMatrixFlag.Default, ColorAdjustType.Bitmap);

            int 坐标X = 0;
            int 坐标Y = 0;
            获取绘制位置(绘制位置, 图片.Width, 图片.Height, 水印图片.Width, 水印图片.Height, out 坐标X, out 坐标Y);
            绘图.DrawImage(水印图片, new Rectangle(坐标X, 坐标Y, 水印图片.Width, 水印图片.Height), 0, 0, 水印图片.Width, 水印图片.Height, GraphicsUnit.Pixel, 图片属性);

            绘图.Dispose();
            水印图片.Dispose();
            图片.Dispose();
            return 位图;
        }
        /// <summary>
        /// 向图片增加水印文字
        /// </summary>
        /// <param name="图片">要增加水印的图片</param>
        /// <param name="绘制位置">水印文字的绘制位置</param>
        /// <param name="水印文字">水印的文字内容</param>
        /// <param name="文字颜色">水印文字的颜色</param>
        /// <param name="字体">水印文字的字体</param>
        /// <param name="字体大小">水印文字的字体大小</param>
        /// <param name="是否加粗">水印文字是否加粗显示</param>
        /// <returns>生成结果</returns>
        public Image 增加文字水印(Image 图片, int 绘制位置, String 水印文字, Color 文字颜色, String 字体, int 字体大小, bool 是否加粗)
        {
            Bitmap 位图 = new Bitmap(图片.Width, 图片.Height);
            Graphics 绘图 = Graphics.FromImage(位图);
            绘图.DrawImage(图片, 0, 0,图片.Width,图片.Height);
            Font _字体 = new Font(字体, 字体大小, 是否加粗 ? FontStyle.Bold : FontStyle.Regular, GraphicsUnit.Pixel);
            SizeF 文字大小 = 绘图.MeasureString(水印文字, _字体);
            int 坐标X = 0;
            int 坐标Y = 0;
            获取绘制位置(绘制位置, 图片.Width, 图片.Height, (int)文字大小.Width, (int)文字大小.Height, out 坐标X, out 坐标Y);
            绘图.DrawString(水印文字, _字体, new SolidBrush(文字颜色), 坐标X, 坐标Y);

            绘图.Dispose();
            图片.Dispose();
            return 位图;
        }
        /// <summary>
        /// 获取水印内容的绘制位置
        /// </summary>
        /// <param name="绘制位置">水印的绘制位置</param>
        /// <param name="图片宽度">图片的宽度</param>
        /// <param name="图片高度">图片的高度</param>
        /// <param name="水印宽度">水印的宽度</param>
        /// <param name="水印高度">水印的高度</param>
        /// <param name="位置X">绘制位置坐标X</param>
        /// <param name="位置Y">绘制位置坐标Y</param>
        private void 获取绘制位置(int 绘制位置,int 图片宽度,int 图片高度,int 水印宽度,int 水印高度,out int 位置X,out int 位置Y)
        {
            switch (绘制位置)
            {
                case 1:
                    位置X = (int)(图片宽度 * (float).01);
                    位置Y = (int)(图片高度 * (float).01);
                    break;
                case 2:
                    位置X = (int)((图片宽度 * (float).50) - (水印宽度 / 2));
                    位置Y = (int)(图片高度 * (float).01);
                    break;
                case 3:
                    位置X = (int)((图片宽度 * (float).99) - 水印宽度);
                    位置Y = (int)(图片高度 * (float).01);
                    break;
                case 4:
                    位置X = (int)(图片宽度 * (float).01);
                    位置Y = (int)(图片高度 * (float).50) - (水印高度 / 2);
                    break;
                case 5:
                    位置X = (int)((图片宽度 * (float).50) - (水印宽度 / 2));
                    位置Y = (int)((图片高度 * (float).50) - (水印高度 / 2));
                    break;
                case 6:
                    位置X = (int)((图片宽度 * (float).99) - 水印宽度);
                    位置Y = (int)((图片高度 * (float).50) - (水印高度 / 2));
                    break;
                case 7:
                    位置X = (int)(图片宽度 * (float).01);
                    位置Y = (int)((图片高度 * .99) - 水印高度);
                    break;
                case 8:
                    位置X = (int)((图片宽度 * (float).50) - (水印宽度 / 2));
                    位置Y = (int)((图片高度 * (float).99) - 水印高度);
                    break;
                default:
                    位置X = (int)((图片宽度 * (float).99) - 水印宽度);
                    位置Y = (int)((图片高度 * (float).99) - 水印高度);
                    break;
            }
        }
    }
}